﻿<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="System.Collections" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Text" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Dokumenty sprzedaży</title>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">
/*
public class ParametryContext : ContextBase { 
	public ParametryContext(Context cx) : base(cx) {
	}
	
	bool duplikatyDokumentów = true;
	
	[Priority(1)]
	public bool DuplikatyDokumentów {
		get { return duplikatyDokumentów; }
		set { duplikatyDokumentów = value; }
	}
	
}

ParametryContext parametry;

[Context]
public ParametryContext Parametry {
	get { return parametry; }
	set { parametry = value; }
}
*/

public class BłędnyDokument : IComparable {

	readonly ArrayList błędy = new ArrayList();

	public BłędnyDokument(DokumentHandlowy dokument) {
		this.dokument = dokument;
	}
	
	DokumentHandlowy dokument;
	
	public DokumentHandlowy Dokument {
		get { return dokument; }
	}
	
	public IList Błędy {
		get { return błędy; }
	}
	
	public void DodajBłąd(string info) {
		błędy.Add(info);
	}
	
	public int CompareTo(object v) {
		BłędnyDokument bd = (BłędnyDokument)v;
		return string.Compare(Dokument.Numer.Pelny, bd.Dokument.Numer.Pelny);
	}
	
}

Hashtable ht = new Hashtable();

BłędnyDokument Błąd(DokumentHandlowy dokument) {
	BłędnyDokument błąd = (BłędnyDokument)ht[dokument];
	if (błąd==null) {
		błąd = new BłędnyDokument(dokument);
		ht[dokument] = błąd;
	}
	return błąd;
}


void sprawdźMM(DokumentHandlowy dok, DokumentHandlowy dokZ, DokumentHandlowy dokDo) {
	Set istniejącePozycje = new Set();
	
	if (dokZ.Stan!=dok.Stan)
		Błąd(dok).DodajBłąd("Stan dokumentu "+dokZ+" jest niezgodny z MM.");
	if (dokDo.Stan!=dok.Stan)
		Błąd(dok).DodajBłąd("Stan dokumentu "+dokDo+" jest niezgodny z MM.");
	
	foreach (PozycjaDokHandlowego poz in dok.Pozycje) {
		istniejącePozycje += poz;
		
		PozycjaDokHandlowego pozZ = null, pozDo = null;
		foreach (PozycjaRelacjiHandlowej pozr in poz.PodrzędneRelacje)
			if (pozr.Relacja.Typ==TypRelacjiHandlowej.Przesunięcie) {
				if (pozZ!=null)
					Błąd(dok).DodajBłąd("Więcej niż jedna pozycja MMW "+poz);
				pozZ = pozr.Podrzedna;
			}
			else if (pozr.Relacja.Typ==TypRelacjiHandlowej.PrzesunięcieDo) {
				if (pozDo!=null)
					Błąd(dok).DodajBłąd("Więcej niż jedna pozycja MMP "+poz);
				pozDo = pozr.Podrzedna;
			}
				
		if (pozZ!=null || pozDo!=null) {
			if (pozZ==null)
				Błąd(dok).DodajBłąd("Pozycja dokumentu "+poz+" nie posiada rozchodu MMW");
			else if (pozDo==null)
				Błąd(dok).DodajBłąd("Pozycja dokumentu "+poz+" nie posiada przychodu MMP");
			else {
				istniejącePozycje += pozZ;
				istniejącePozycje += pozDo;
				
				if (poz.Ilosc!=pozZ.Ilosc)
					Błąd(dok).DodajBłąd("Niezgodna ilość pozycji "+poz+" z dokumentem MMW");
				if (poz.Ilosc!=pozDo.Ilosc)
					Błąd(dok).DodajBłąd("Niezgodna ilość pozycji "+poz+" z dokumentem MMP");

				if (poz.WartoscCy!=pozZ.WartoscCy)
					Błąd(dok).DodajBłąd("Niezgodna wartość pozycji "+poz+" z dokumentem MMW");
				if (poz.WartoscCy!=pozDo.WartoscCy)
					Błąd(dok).DodajBłąd("Niezgodna wartość pozycji "+poz+" z dokumentem MMP");
			}
		}
	}
}


void dc_ContextLoad(Object sender, EventArgs args) {

	int licznik = 0;
	foreach (DokumentHandlowy dok in (Row[])dc[typeof(Row[])]) {
		if (++licznik % 100 == 0)
			System.Diagnostics.Trace.Write("Analizuje dokumenty: "+licznik, "Progress");
			
		DokumentHandlowy dokZ = null, dokDo = null;
		foreach (RelacjaHandlowa relacja in dok.PodrzedneRelacje)
			if (relacja.Typ==TypRelacjiHandlowej.Przesunięcie)
				dokZ = relacja.Podrzedny;
			else if (relacja.Typ==TypRelacjiHandlowej.PrzesunięcieDo)
				dokDo = relacja.Podrzedny;
		if (dokZ!=null || dokDo!=null) {
			if (dokZ==null)
				Błąd(dok).DodajBłąd("Dokument nie posiada rozchodu MMW");
			else if (dokDo==null)
				Błąd(dok).DodajBłąd("Dokument nie posiada przychodu MMP");
			else
				sprawdźMM(dok, dokZ, dokDo);
		}
	}
	
	ArrayList arr = new ArrayList(ht.Values);
	arr.Sort();
	Grid.DataSource = arr;
}


		</script>
	</HEAD>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" title="Weryfikacja MM</strong>|Raport zawiera dokumenty podejrzane o wystąpienie w nich pewnych błędów."
				runat="server"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="18" Align="Left" DataMember="Dokument.Numer" Caption="Numer" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Center" DataMember="Dokument.Data" Caption="Data" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" DataMember="Dokument.Suma.Netto" Caption="Netto" Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn DataMember="Błędy" Caption="Opis problemu" EncodeHTML="True" runat="server"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</form>
	</body>
</HTML>

